package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.ListIdentityProviderConfigsRequestMaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdentityProviderConfigsRequest(
    clusterName: String,
    maxResults: Optional[ListIdentityProviderConfigsRequestMaxResults] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest = {
    import ListIdentityProviderConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListIdentityProviderConfigsRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.ListIdentityProviderConfigsRequest.ReadOnly =
    zio.aws.eks.model.ListIdentityProviderConfigsRequest.wrap(buildAwsValue())
}
object ListIdentityProviderConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListIdentityProviderConfigsRequest =
      zio.aws.eks.model.ListIdentityProviderConfigsRequest(
        clusterName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterName: String
    def maxResults: Optional[ListIdentityProviderConfigsRequestMaxResults]
    def nextToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getMaxResults
        : ZIO[Any, AwsError, ListIdentityProviderConfigsRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest
  ) extends zio.aws.eks.model.ListIdentityProviderConfigsRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val maxResults
        : Optional[ListIdentityProviderConfigsRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives
            .ListIdentityProviderConfigsRequestMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest
  ): zio.aws.eks.model.ListIdentityProviderConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
