package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAddonResponse(
    addon: Optional[zio.aws.eks.model.Addon] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonResponse = {
    import DescribeAddonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonResponse
      .builder()
      .optionallyWith(addon.map(value => value.buildAwsValue()))(_.addon)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonResponse.ReadOnly =
    zio.aws.eks.model.DescribeAddonResponse.wrap(buildAwsValue())
}
object DescribeAddonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonResponse = zio.aws.eks.model
      .DescribeAddonResponse(addon.map(value => value.asEditable))
    def addon: Optional[zio.aws.eks.model.Addon.ReadOnly]
    def getAddon: ZIO[Any, AwsError, zio.aws.eks.model.Addon.ReadOnly] =
      AwsError.unwrapOptionField("addon", addon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonResponse
  ) extends zio.aws.eks.model.DescribeAddonResponse.ReadOnly {
    override val addon: Optional[zio.aws.eks.model.Addon.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addon())
        .map(value => zio.aws.eks.model.Addon.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonResponse
  ): zio.aws.eks.model.DescribeAddonResponse.ReadOnly = new Wrapper(impl)
}
