package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{RoleArn, ClusterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAddonRequest(
    clusterName: ClusterName,
    addonName: String,
    addonVersion: Optional[String] = Optional.Absent,
    serviceAccountRoleArn: Optional[RoleArn] = Optional.Absent,
    resolveConflicts: Optional[zio.aws.eks.model.ResolveConflicts] =
      Optional.Absent,
    clientRequestToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateAddonRequest = {
    import UpdateAddonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateAddonRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .addonName(addonName: java.lang.String)
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(
        serviceAccountRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.serviceAccountRoleArn)
      .optionallyWith(resolveConflicts.map(value => value.unwrap))(
        _.resolveConflicts
      )
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateAddonRequest.ReadOnly =
    zio.aws.eks.model.UpdateAddonRequest.wrap(buildAwsValue())
}
object UpdateAddonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateAddonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateAddonRequest =
      zio.aws.eks.model.UpdateAddonRequest(
        clusterName,
        addonName,
        addonVersion.map(value => value),
        serviceAccountRoleArn.map(value => value),
        resolveConflicts.map(value => value),
        clientRequestToken.map(value => value)
      )
    def clusterName: ClusterName
    def addonName: String
    def addonVersion: Optional[String]
    def serviceAccountRoleArn: Optional[RoleArn]
    def resolveConflicts: Optional[zio.aws.eks.model.ResolveConflicts]
    def clientRequestToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getAddonName: ZIO[Any, Nothing, String] = ZIO.succeed(addonName)
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getServiceAccountRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("serviceAccountRoleArn", serviceAccountRoleArn)
    def getResolveConflicts
        : ZIO[Any, AwsError, zio.aws.eks.model.ResolveConflicts] =
      AwsError.unwrapOptionField("resolveConflicts", resolveConflicts)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateAddonRequest
  ) extends zio.aws.eks.model.UpdateAddonRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.clusterName())
    override val addonName: String = impl.addonName(): String
    override val addonVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonVersion())
      .map(value => value: String)
    override val serviceAccountRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceAccountRoleArn())
        .map(value => zio.aws.eks.model.primitives.RoleArn(value))
    override val resolveConflicts
        : Optional[zio.aws.eks.model.ResolveConflicts] = zio.aws.core.internal
      .optionalFromNullable(impl.resolveConflicts())
      .map(value => zio.aws.eks.model.ResolveConflicts.wrap(value))
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateAddonRequest
  ): zio.aws.eks.model.UpdateAddonRequest.ReadOnly = new Wrapper(impl)
}
