package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterResponse(
    cluster: Optional[zio.aws.eks.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeClusterResponse.ReadOnly =
    zio.aws.eks.model.DescribeClusterResponse.wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeClusterResponse =
      zio.aws.eks.model
        .DescribeClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.eks.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeClusterResponse
  ) extends zio.aws.eks.model.DescribeClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.eks.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeClusterResponse
  ): zio.aws.eks.model.DescribeClusterResponse.ReadOnly = new Wrapper(impl)
}
