package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClusterResponse(
    cluster: Optional[zio.aws.eks.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateClusterResponse.ReadOnly =
    zio.aws.eks.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateClusterResponse = zio.aws.eks.model
      .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.eks.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateClusterResponse
  ) extends zio.aws.eks.model.CreateClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.eks.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateClusterResponse
  ): zio.aws.eks.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
