package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddonVersionInfo(
    addonVersion: Optional[String] = Optional.Absent,
    architecture: Optional[Iterable[String]] = Optional.Absent,
    compatibilities: Optional[Iterable[zio.aws.eks.model.Compatibility]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AddonVersionInfo = {
    import AddonVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AddonVersionInfo
      .builder()
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(
        architecture.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.architecture)
      .optionallyWith(
        compatibilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibilities)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AddonVersionInfo.ReadOnly =
    zio.aws.eks.model.AddonVersionInfo.wrap(buildAwsValue())
}
object AddonVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AddonVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AddonVersionInfo =
      zio.aws.eks.model.AddonVersionInfo(
        addonVersion.map(value => value),
        architecture.map(value => value),
        compatibilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def addonVersion: Optional[String]
    def architecture: Optional[List[String]]
    def compatibilities
        : Optional[List[zio.aws.eks.model.Compatibility.ReadOnly]]
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getArchitecture: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.eks.model.Compatibility.ReadOnly]] =
      AwsError.unwrapOptionField("compatibilities", compatibilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AddonVersionInfo
  ) extends zio.aws.eks.model.AddonVersionInfo.ReadOnly {
    override val addonVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonVersion())
      .map(value => value: String)
    override val architecture: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val compatibilities
        : Optional[List[zio.aws.eks.model.Compatibility.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.Compatibility.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AddonVersionInfo
  ): zio.aws.eks.model.AddonVersionInfo.ReadOnly = new Wrapper(impl)
}
