package zio.aws.eks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp, ClusterName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Addon(
    addonName: Optional[String] = Optional.Absent,
    clusterName: Optional[ClusterName] = Optional.Absent,
    status: Optional[zio.aws.eks.model.AddonStatus] = Optional.Absent,
    addonVersion: Optional[String] = Optional.Absent,
    health: Optional[zio.aws.eks.model.AddonHealth] = Optional.Absent,
    addonArn: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    modifiedAt: Optional[Timestamp] = Optional.Absent,
    serviceAccountRoleArn: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Addon = {
    import Addon.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Addon
      .builder()
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(
        clusterName.map(value => ClusterName.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .optionallyWith(addonArn.map(value => value: java.lang.String))(
        _.addonArn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .optionallyWith(
        serviceAccountRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccountRoleArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Addon.ReadOnly =
    zio.aws.eks.model.Addon.wrap(buildAwsValue())
}
object Addon {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Addon] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Addon = zio.aws.eks.model.Addon(
      addonName.map(value => value),
      clusterName.map(value => value),
      status.map(value => value),
      addonVersion.map(value => value),
      health.map(value => value.asEditable),
      addonArn.map(value => value),
      createdAt.map(value => value),
      modifiedAt.map(value => value),
      serviceAccountRoleArn.map(value => value),
      tags.map(value => value)
    )
    def addonName: Optional[String]
    def clusterName: Optional[ClusterName]
    def status: Optional[zio.aws.eks.model.AddonStatus]
    def addonVersion: Optional[String]
    def health: Optional[zio.aws.eks.model.AddonHealth.ReadOnly]
    def addonArn: Optional[String]
    def createdAt: Optional[Timestamp]
    def modifiedAt: Optional[Timestamp]
    def serviceAccountRoleArn: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getClusterName: ZIO[Any, AwsError, ClusterName] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.AddonStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getHealth: ZIO[Any, AwsError, zio.aws.eks.model.AddonHealth.ReadOnly] =
      AwsError.unwrapOptionField("health", health)
    def getAddonArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonArn", addonArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getServiceAccountRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccountRoleArn", serviceAccountRoleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Addon
  ) extends zio.aws.eks.model.Addon.ReadOnly {
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
    override val clusterName: Optional[ClusterName] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => zio.aws.eks.model.primitives.ClusterName(value))
    override val status: Optional[zio.aws.eks.model.AddonStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.eks.model.AddonStatus.wrap(value))
    override val addonVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonVersion())
      .map(value => value: String)
    override val health: Optional[zio.aws.eks.model.AddonHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.eks.model.AddonHealth.wrap(value))
    override val addonArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonArn())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val modifiedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val serviceAccountRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccountRoleArn())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Addon
  ): zio.aws.eks.model.Addon.ReadOnly = new Wrapper(impl)
}
