package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateNodegroupVersionRequest(
    clusterName: String,
    nodegroupName: String,
    version: Option[String] = None,
    releaseVersion: Option[String] = None,
    launchTemplate: Option[zio.aws.eks.model.LaunchTemplateSpecification] =
      None,
    force: Option[Boolean] = None,
    clientRequestToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest = {
    import UpdateNodegroupVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(releaseVersion.map(value => value: java.lang.String))(
        _.releaseVersion
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateNodegroupVersionRequest.ReadOnly =
    zio.aws.eks.model.UpdateNodegroupVersionRequest.wrap(buildAwsValue())
}
object UpdateNodegroupVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateNodegroupVersionRequest =
      zio.aws.eks.model.UpdateNodegroupVersionRequest(
        clusterName,
        nodegroupName,
        version.map(value => value),
        releaseVersion.map(value => value),
        launchTemplate.map(value => value.asEditable),
        force.map(value => value),
        clientRequestToken.map(value => value)
      )
    def clusterName: String
    def nodegroupName: String
    def version: Option[String]
    def releaseVersion: Option[String]
    def launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly]
    def force: Option[Boolean]
    def clientRequestToken: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getReleaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest
  ) extends zio.aws.eks.model.UpdateNodegroupVersionRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val releaseVersion: Option[String] =
      scala.Option(impl.releaseVersion()).map(value => value: String)
    override val launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.eks.model.LaunchTemplateSpecification.wrap(value))
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest
  ): zio.aws.eks.model.UpdateNodegroupVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
