package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterVersionResponse(
    update: Option[zio.aws.eks.model.Update] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse = {
    import UpdateClusterVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly =
    zio.aws.eks.model.UpdateClusterVersionResponse.wrap(buildAwsValue())
}
object UpdateClusterVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateClusterVersionResponse =
      zio.aws.eks.model
        .UpdateClusterVersionResponse(update.map(value => value.asEditable))
    def update: Option[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse
  ) extends zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly {
    override val update: Option[zio.aws.eks.model.Update.ReadOnly] = scala
      .Option(impl.update())
      .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse
  ): zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly = new Wrapper(impl)
}
