package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteNodegroupResponse(
    nodegroup: Option[zio.aws.eks.model.Nodegroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse = {
    import DeleteNodegroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse
      .builder()
      .optionallyWith(nodegroup.map(value => value.buildAwsValue()))(
        _.nodegroup
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly =
    zio.aws.eks.model.DeleteNodegroupResponse.wrap(buildAwsValue())
}
object DeleteNodegroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteNodegroupResponse =
      zio.aws.eks.model
        .DeleteNodegroupResponse(nodegroup.map(value => value.asEditable))
    def nodegroup: Option[zio.aws.eks.model.Nodegroup.ReadOnly]
    def getNodegroup: ZIO[Any, AwsError, zio.aws.eks.model.Nodegroup.ReadOnly] =
      AwsError.unwrapOptionField("nodegroup", nodegroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse
  ) extends zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly {
    override val nodegroup: Option[zio.aws.eks.model.Nodegroup.ReadOnly] = scala
      .Option(impl.nodegroup())
      .map(value => zio.aws.eks.model.Nodegroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse
  ): zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly = new Wrapper(impl)
}
