package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait CapacityTypes {
  def unwrap: software.amazon.awssdk.services.eks.model.CapacityTypes
}
object CapacityTypes {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.CapacityTypes
  ): zio.aws.eks.model.CapacityTypes = value match {
    case software.amazon.awssdk.services.eks.model.CapacityTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.CapacityTypes.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.eks.model.CapacityTypes.SPOT =>
      val r = SPOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.CapacityTypes {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.CapacityTypes =
      software.amazon.awssdk.services.eks.model.CapacityTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND extends zio.aws.eks.model.CapacityTypes {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.CapacityTypes =
      software.amazon.awssdk.services.eks.model.CapacityTypes.ON_DEMAND
  }
  case object SPOT extends zio.aws.eks.model.CapacityTypes {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.CapacityTypes =
      software.amazon.awssdk.services.eks.model.CapacityTypes.SPOT
  }
}
