package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Update(
    id: Option[String] = None,
    status: Option[zio.aws.eks.model.UpdateStatus] = None,
    `type`: Option[zio.aws.eks.model.UpdateType] = None,
    params: Option[Iterable[zio.aws.eks.model.UpdateParam]] = None,
    createdAt: Option[Timestamp] = None,
    errors: Option[Iterable[zio.aws.eks.model.ErrorDetail]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Update = {
    import Update.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Update
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        params.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.params)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Update.ReadOnly =
    zio.aws.eks.model.Update.wrap(buildAwsValue())
}
object Update {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Update] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Update = zio.aws.eks.model.Update(
      id.map(value => value),
      status.map(value => value),
      `type`.map(value => value),
      params.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdAt.map(value => value),
      errors.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[String]
    def status: Option[zio.aws.eks.model.UpdateStatus]
    def `type`: Option[zio.aws.eks.model.UpdateType]
    def params: Option[List[zio.aws.eks.model.UpdateParam.ReadOnly]]
    def createdAt: Option[Timestamp]
    def errors: Option[List[zio.aws.eks.model.ErrorDetail.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.UpdateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.eks.model.UpdateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getParams
        : ZIO[Any, AwsError, List[zio.aws.eks.model.UpdateParam.ReadOnly]] =
      AwsError.unwrapOptionField("params", params)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.eks.model.ErrorDetail.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Update
  ) extends zio.aws.eks.model.Update.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val status: Option[zio.aws.eks.model.UpdateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.UpdateStatus.wrap(value))
    override val `type`: Option[zio.aws.eks.model.UpdateType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.eks.model.UpdateType.wrap(value))
    override val params: Option[List[zio.aws.eks.model.UpdateParam.ReadOnly]] =
      scala
        .Option(impl.params())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.UpdateParam.wrap(item)
          }.toList
        )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val errors: Option[List[zio.aws.eks.model.ErrorDetail.ReadOnly]] =
      scala
        .Option(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.ErrorDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Update
  ): zio.aws.eks.model.Update.ReadOnly = new Wrapper(impl)
}
