package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FargateProfile(
    fargateProfileName: Option[String] = None,
    fargateProfileArn: Option[String] = None,
    clusterName: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    podExecutionRoleArn: Option[String] = None,
    subnets: Option[Iterable[String]] = None,
    selectors: Option[Iterable[zio.aws.eks.model.FargateProfileSelector]] =
      None,
    status: Option[zio.aws.eks.model.FargateProfileStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.FargateProfile = {
    import FargateProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.FargateProfile
      .builder()
      .optionallyWith(fargateProfileName.map(value => value: java.lang.String))(
        _.fargateProfileName
      )
      .optionallyWith(fargateProfileArn.map(value => value: java.lang.String))(
        _.fargateProfileArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        podExecutionRoleArn.map(value => value: java.lang.String)
      )(_.podExecutionRoleArn)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.FargateProfile.ReadOnly =
    zio.aws.eks.model.FargateProfile.wrap(buildAwsValue())
}
object FargateProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.FargateProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.FargateProfile =
      zio.aws.eks.model.FargateProfile(
        fargateProfileName.map(value => value),
        fargateProfileArn.map(value => value),
        clusterName.map(value => value),
        createdAt.map(value => value),
        podExecutionRoleArn.map(value => value),
        subnets.map(value => value),
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        tags.map(value => value)
      )
    def fargateProfileName: Option[String]
    def fargateProfileArn: Option[String]
    def clusterName: Option[String]
    def createdAt: Option[Timestamp]
    def podExecutionRoleArn: Option[String]
    def subnets: Option[List[String]]
    def selectors
        : Option[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]]
    def status: Option[zio.aws.eks.model.FargateProfileStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def getFargateProfileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fargateProfileName", fargateProfileName)
    def getFargateProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fargateProfileArn", fargateProfileArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPodExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("podExecutionRoleArn", podExecutionRoleArn)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.eks.model.FargateProfileSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.FargateProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.FargateProfile
  ) extends zio.aws.eks.model.FargateProfile.ReadOnly {
    override val fargateProfileName: Option[String] =
      scala.Option(impl.fargateProfileName()).map(value => value: String)
    override val fargateProfileArn: Option[String] =
      scala.Option(impl.fargateProfileArn()).map(value => value: String)
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val podExecutionRoleArn: Option[String] =
      scala.Option(impl.podExecutionRoleArn()).map(value => value: String)
    override val subnets: Option[List[String]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val selectors
        : Option[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]] =
      scala
        .Option(impl.selectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.FargateProfileSelector.wrap(item)
          }.toList
        )
    override val status: Option[zio.aws.eks.model.FargateProfileStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.FargateProfileStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.FargateProfile
  ): zio.aws.eks.model.FargateProfile.ReadOnly = new Wrapper(impl)
}
