package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ErrorDetail(
    errorCode: Option[zio.aws.eks.model.ErrorCode] = None,
    errorMessage: Option[String] = None,
    resourceIds: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.ErrorDetail = {
    import ErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ErrorDetail.ReadOnly =
    zio.aws.eks.model.ErrorDetail.wrap(buildAwsValue())
}
object ErrorDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.ErrorDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ErrorDetail =
      zio.aws.eks.model.ErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        resourceIds.map(value => value)
      )
    def errorCode: Option[zio.aws.eks.model.ErrorCode]
    def errorMessage: Option[String]
    def resourceIds: Option[List[String]]
    def getErrorCode: ZIO[Any, AwsError, zio.aws.eks.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ErrorDetail
  ) extends zio.aws.eks.model.ErrorDetail.ReadOnly {
    override val errorCode: Option[zio.aws.eks.model.ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.eks.model.ErrorCode.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val resourceIds: Option[List[String]] = scala
      .Option(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ErrorDetail
  ): zio.aws.eks.model.ErrorDetail.ReadOnly = new Wrapper(impl)
}
