package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Compatibility(
    clusterVersion: Option[String] = None,
    platformVersions: Option[Iterable[String]] = None,
    defaultVersion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.Compatibility = {
    import Compatibility.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Compatibility
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        platformVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.platformVersions)
      .optionallyWith(defaultVersion.map(value => value: java.lang.Boolean))(
        _.defaultVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Compatibility.ReadOnly =
    zio.aws.eks.model.Compatibility.wrap(buildAwsValue())
}
object Compatibility {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Compatibility] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Compatibility =
      zio.aws.eks.model.Compatibility(
        clusterVersion.map(value => value),
        platformVersions.map(value => value),
        defaultVersion.map(value => value)
      )
    def clusterVersion: Option[String]
    def platformVersions: Option[List[String]]
    def defaultVersion: Option[Boolean]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getPlatformVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("platformVersions", platformVersions)
    def getDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Compatibility
  ) extends zio.aws.eks.model.Compatibility.ReadOnly {
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val platformVersions: Option[List[String]] = scala
      .Option(impl.platformVersions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val defaultVersion: Option[Boolean] =
      scala.Option(impl.defaultVersion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Compatibility
  ): zio.aws.eks.model.Compatibility.ReadOnly = new Wrapper(impl)
}
