package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ResolveConflicts {
  def unwrap: software.amazon.awssdk.services.eks.model.ResolveConflicts
}
object ResolveConflicts {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ResolveConflicts
  ): zio.aws.eks.model.ResolveConflicts = value match {
    case software.amazon.awssdk.services.eks.model.ResolveConflicts.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ResolveConflicts.OVERWRITE =>
      val r = OVERWRITE
      r
    case software.amazon.awssdk.services.eks.model.ResolveConflicts.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ResolveConflicts {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ResolveConflicts =
      software.amazon.awssdk.services.eks.model.ResolveConflicts.UNKNOWN_TO_SDK_VERSION
  }
  case object OVERWRITE extends zio.aws.eks.model.ResolveConflicts {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ResolveConflicts =
      software.amazon.awssdk.services.eks.model.ResolveConflicts.OVERWRITE
  }
  case object NONE extends zio.aws.eks.model.ResolveConflicts {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ResolveConflicts =
      software.amazon.awssdk.services.eks.model.ResolveConflicts.NONE
  }
}
