package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFargateProfileResponse(
    fargateProfile: Option[zio.aws.eks.model.FargateProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse = {
    import DescribeFargateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse
      .builder()
      .optionallyWith(fargateProfile.map(value => value.buildAwsValue()))(
        _.fargateProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly =
    zio.aws.eks.model.DescribeFargateProfileResponse.wrap(buildAwsValue())
}
object DescribeFargateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeFargateProfileResponse =
      zio.aws.eks.model.DescribeFargateProfileResponse(
        fargateProfile.map(value => value.asEditable)
      )
    def fargateProfile: Option[zio.aws.eks.model.FargateProfile.ReadOnly]
    def getFargateProfile
        : ZIO[Any, AwsError, zio.aws.eks.model.FargateProfile.ReadOnly] =
      AwsError.unwrapOptionField("fargateProfile", fargateProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse
  ) extends zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly {
    override val fargateProfile
        : Option[zio.aws.eks.model.FargateProfile.ReadOnly] = scala
      .Option(impl.fargateProfile())
      .map(value => zio.aws.eks.model.FargateProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse
  ): zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
