package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateEncryptionConfigResponse(
    update: Option[zio.aws.eks.model.Update] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse = {
    import AssociateEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly =
    zio.aws.eks.model.AssociateEncryptionConfigResponse.wrap(buildAwsValue())
}
object AssociateEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AssociateEncryptionConfigResponse =
      zio.aws.eks.model.AssociateEncryptionConfigResponse(
        update.map(value => value.asEditable)
      )
    def update: Option[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse
  ) extends zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly {
    override val update: Option[zio.aws.eks.model.Update.ReadOnly] = scala
      .Option(impl.update())
      .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse
  ): zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
