package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Provider(keyArn: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Provider = {
    import Provider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Provider
      .builder()
      .optionallyWith(keyArn.map(value => value: java.lang.String))(_.keyArn)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Provider.ReadOnly =
    zio.aws.eks.model.Provider.wrap(buildAwsValue())
}
object Provider {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Provider] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Provider =
      zio.aws.eks.model.Provider(keyArn.map(value => value))
    def keyArn: Option[String]
    def getKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Provider
  ) extends zio.aws.eks.model.Provider.ReadOnly {
    override val keyArn: Option[String] =
      scala.Option(impl.keyArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Provider
  ): zio.aws.eks.model.Provider.ReadOnly = new Wrapper(impl)
}
