package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodegroupResources(
    autoScalingGroups: Option[Iterable[zio.aws.eks.model.AutoScalingGroup]] =
      None,
    remoteAccessSecurityGroup: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupResources = {
    import NodegroupResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupResources
      .builder()
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        remoteAccessSecurityGroup.map(value => value: java.lang.String)
      )(_.remoteAccessSecurityGroup)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupResources.ReadOnly =
    zio.aws.eks.model.NodegroupResources.wrap(buildAwsValue())
}
object NodegroupResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupResources =
      zio.aws.eks.model.NodegroupResources(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remoteAccessSecurityGroup.map(value => value)
      )
    def autoScalingGroups
        : Option[List[zio.aws.eks.model.AutoScalingGroup.ReadOnly]]
    def remoteAccessSecurityGroup: Option[String]
    def getAutoScalingGroups: ZIO[Any, AwsError, List[
      zio.aws.eks.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getRemoteAccessSecurityGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("remoteAccessSecurityGroup", remoteAccessSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupResources
  ) extends zio.aws.eks.model.NodegroupResources.ReadOnly {
    override val autoScalingGroups
        : Option[List[zio.aws.eks.model.AutoScalingGroup.ReadOnly]] = scala
      .Option(impl.autoScalingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.AutoScalingGroup.wrap(item)
        }.toList
      )
    override val remoteAccessSecurityGroup: Option[String] =
      scala.Option(impl.remoteAccessSecurityGroup()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupResources
  ): zio.aws.eks.model.NodegroupResources.ReadOnly = new Wrapper(impl)
}
