package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoteAccessConfig(
    ec2SshKey: Option[String] = None,
    sourceSecurityGroups: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.RemoteAccessConfig = {
    import RemoteAccessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.RemoteAccessConfig
      .builder()
      .optionallyWith(ec2SshKey.map(value => value: java.lang.String))(
        _.ec2SshKey
      )
      .optionallyWith(
        sourceSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.RemoteAccessConfig.ReadOnly =
    zio.aws.eks.model.RemoteAccessConfig.wrap(buildAwsValue())
}
object RemoteAccessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.RemoteAccessConfig =
      zio.aws.eks.model.RemoteAccessConfig(
        ec2SshKey.map(value => value),
        sourceSecurityGroups.map(value => value)
      )
    def ec2SshKey: Option[String]
    def sourceSecurityGroups: Option[List[String]]
    def getEc2SshKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SshKey", ec2SshKey)
    def getSourceSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceSecurityGroups", sourceSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ) extends zio.aws.eks.model.RemoteAccessConfig.ReadOnly {
    override val ec2SshKey: Option[String] =
      scala.Option(impl.ec2SshKey()).map(value => value: String)
    override val sourceSecurityGroups: Option[List[String]] = scala
      .Option(impl.sourceSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ): zio.aws.eks.model.RemoteAccessConfig.ReadOnly = new Wrapper(impl)
}
