package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class AssociateIdentityProviderConfigRequest(
    clusterName: String,
    oidc: zio.aws.eks.model.OidcIdentityProviderConfigRequest,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientRequestToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest = {
    import AssociateIdentityProviderConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .oidc(oidc.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.AssociateIdentityProviderConfigRequest.ReadOnly =
    zio.aws.eks.model.AssociateIdentityProviderConfigRequest
      .wrap(buildAwsValue())
}
object AssociateIdentityProviderConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AssociateIdentityProviderConfigRequest =
      zio.aws.eks.model.AssociateIdentityProviderConfigRequest(
        clusterName,
        oidc.asEditable,
        tags.map(value => value),
        clientRequestToken.map(value => value)
      )
    def clusterName: String
    def oidc: zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def clientRequestToken: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getOidc: ZIO[
      Any,
      Nothing,
      zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly
    ] = ZIO.succeed(oidc)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest
  ) extends zio.aws.eks.model.AssociateIdentityProviderConfigRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val oidc
        : zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly =
      zio.aws.eks.model.OidcIdentityProviderConfigRequest.wrap(impl.oidc())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest
  ): zio.aws.eks.model.AssociateIdentityProviderConfigRequest.ReadOnly =
    new Wrapper(impl)
}
