package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OIDC(issuer: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.OIDC = {
    import OIDC.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OIDC
      .builder()
      .optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OIDC.ReadOnly =
    zio.aws.eks.model.OIDC.wrap(buildAwsValue())
}
object OIDC {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.OIDC] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OIDC =
      zio.aws.eks.model.OIDC(issuer.map(value => value))
    def issuer: Option[String]
    def getIssuer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuer", issuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OIDC
  ) extends zio.aws.eks.model.OIDC.ReadOnly {
    override val issuer: Option[String] =
      scala.Option(impl.issuer()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OIDC
  ): zio.aws.eks.model.OIDC.ReadOnly = new Wrapper(impl)
}
