package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateNodegroupConfigRequest(
    clusterName: String,
    nodegroupName: String,
    labels: Option[zio.aws.eks.model.UpdateLabelsPayload] = None,
    taints: Option[zio.aws.eks.model.UpdateTaintsPayload] = None,
    scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig] = None,
    updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig] = None,
    clientRequestToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest = {
    import UpdateNodegroupConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .optionallyWith(labels.map(value => value.buildAwsValue()))(_.labels)
      .optionallyWith(taints.map(value => value.buildAwsValue()))(_.taints)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .optionallyWith(updateConfig.map(value => value.buildAwsValue()))(
        _.updateConfig
      )
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateNodegroupConfigRequest.ReadOnly =
    zio.aws.eks.model.UpdateNodegroupConfigRequest.wrap(buildAwsValue())
}
object UpdateNodegroupConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateNodegroupConfigRequest =
      zio.aws.eks.model.UpdateNodegroupConfigRequest(
        clusterName,
        nodegroupName,
        labels.map(value => value.asEditable),
        taints.map(value => value.asEditable),
        scalingConfig.map(value => value.asEditable),
        updateConfig.map(value => value.asEditable),
        clientRequestToken.map(value => value)
      )
    def clusterName: String
    def nodegroupName: String
    def labels: Option[zio.aws.eks.model.UpdateLabelsPayload.ReadOnly]
    def taints: Option[zio.aws.eks.model.UpdateTaintsPayload.ReadOnly]
    def scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly]
    def updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly]
    def clientRequestToken: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
    def getLabels
        : ZIO[Any, AwsError, zio.aws.eks.model.UpdateLabelsPayload.ReadOnly] =
      AwsError.unwrapOptionField("labels", labels)
    def getTaints
        : ZIO[Any, AwsError, zio.aws.eks.model.UpdateTaintsPayload.ReadOnly] =
      AwsError.unwrapOptionField("taints", taints)
    def getScalingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.NodegroupScalingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfig", scalingConfig)
    def getUpdateConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      AwsError.unwrapOptionField("updateConfig", updateConfig)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest
  ) extends zio.aws.eks.model.UpdateNodegroupConfigRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
    override val labels
        : Option[zio.aws.eks.model.UpdateLabelsPayload.ReadOnly] = scala
      .Option(impl.labels())
      .map(value => zio.aws.eks.model.UpdateLabelsPayload.wrap(value))
    override val taints
        : Option[zio.aws.eks.model.UpdateTaintsPayload.ReadOnly] = scala
      .Option(impl.taints())
      .map(value => zio.aws.eks.model.UpdateTaintsPayload.wrap(value))
    override val scalingConfig
        : Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly] = scala
      .Option(impl.scalingConfig())
      .map(value => zio.aws.eks.model.NodegroupScalingConfig.wrap(value))
    override val updateConfig
        : Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] = scala
      .Option(impl.updateConfig())
      .map(value => zio.aws.eks.model.NodegroupUpdateConfig.wrap(value))
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest
  ): zio.aws.eks.model.UpdateNodegroupConfigRequest.ReadOnly = new Wrapper(impl)
}
