package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteAddonResponse(
    addon: Option[zio.aws.eks.model.Addon] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteAddonResponse = {
    import DeleteAddonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteAddonResponse
      .builder()
      .optionallyWith(addon.map(value => value.buildAwsValue()))(_.addon)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteAddonResponse.ReadOnly =
    zio.aws.eks.model.DeleteAddonResponse.wrap(buildAwsValue())
}
object DeleteAddonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteAddonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteAddonResponse = zio.aws.eks.model
      .DeleteAddonResponse(addon.map(value => value.asEditable))
    def addon: Option[zio.aws.eks.model.Addon.ReadOnly]
    def getAddon: ZIO[Any, AwsError, zio.aws.eks.model.Addon.ReadOnly] =
      AwsError.unwrapOptionField("addon", addon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteAddonResponse
  ) extends zio.aws.eks.model.DeleteAddonResponse.ReadOnly {
    override val addon: Option[zio.aws.eks.model.Addon.ReadOnly] = scala
      .Option(impl.addon())
      .map(value => zio.aws.eks.model.Addon.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteAddonResponse
  ): zio.aws.eks.model.DeleteAddonResponse.ReadOnly = new Wrapper(impl)
}
