package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ConnectorConfigProvider {
  def unwrap: software.amazon.awssdk.services.eks.model.ConnectorConfigProvider
}
object ConnectorConfigProvider {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ConnectorConfigProvider
  ): zio.aws.eks.model.ConnectorConfigProvider = value match {
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.EKS_ANYWHERE =>
      val r = EKS_ANYWHERE
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.ANTHOS =>
      val r = ANTHOS
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.GKE =>
      val r = GKE
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.AKS =>
      val r = AKS
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.OPENSHIFT =>
      val r = OPENSHIFT
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.TANZU =>
      val r = TANZU
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.RANCHER =>
      val r = RANCHER
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object EKS_ANYWHERE extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.EKS_ANYWHERE
  }
  case object ANTHOS extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.ANTHOS
  }
  case object GKE extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.GKE
  }
  case object AKS extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.AKS
  }
  case object OPENSHIFT extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.OPENSHIFT
  }
  case object TANZU extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.TANZU
  }
  case object RANCHER extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.RANCHER
  }
  case object EC2 extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.EC2
  }
  case object OTHER extends zio.aws.eks.model.ConnectorConfigProvider {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConnectorConfigProvider =
      software.amazon.awssdk.services.eks.model.ConnectorConfigProvider.OTHER
  }
}
