package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateNodegroupVersionResponse(
    update: Option[zio.aws.eks.model.Update] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse = {
    import UpdateNodegroupVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateNodegroupVersionResponse.ReadOnly =
    zio.aws.eks.model.UpdateNodegroupVersionResponse.wrap(buildAwsValue())
}
object UpdateNodegroupVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateNodegroupVersionResponse =
      zio.aws.eks.model
        .UpdateNodegroupVersionResponse(update.map(value => value.asEditable))
    def update: Option[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse
  ) extends zio.aws.eks.model.UpdateNodegroupVersionResponse.ReadOnly {
    override val update: Option[zio.aws.eks.model.Update.ReadOnly] = scala
      .Option(impl.update())
      .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse
  ): zio.aws.eks.model.UpdateNodegroupVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
