package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{LabelValue, LabelKey}
import scala.jdk.CollectionConverters._
final case class UpdateLabelsPayload(
    addOrUpdateLabels: Option[Map[LabelKey, LabelValue]] = None,
    removeLabels: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateLabelsPayload = {
    import UpdateLabelsPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateLabelsPayload
      .builder()
      .optionallyWith(
        addOrUpdateLabels.map(value =>
          value
            .map({ case (key, value) =>
              (LabelKey.unwrap(key): java.lang.String) -> (LabelValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.addOrUpdateLabels)
      .optionallyWith(
        removeLabels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeLabels)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateLabelsPayload.ReadOnly =
    zio.aws.eks.model.UpdateLabelsPayload.wrap(buildAwsValue())
}
object UpdateLabelsPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateLabelsPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateLabelsPayload =
      zio.aws.eks.model.UpdateLabelsPayload(
        addOrUpdateLabels.map(value => value),
        removeLabels.map(value => value)
      )
    def addOrUpdateLabels: Option[Map[LabelKey, LabelValue]]
    def removeLabels: Option[List[String]]
    def getAddOrUpdateLabels: ZIO[Any, AwsError, Map[LabelKey, LabelValue]] =
      AwsError.unwrapOptionField("addOrUpdateLabels", addOrUpdateLabels)
    def getRemoveLabels: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("removeLabels", removeLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateLabelsPayload
  ) extends zio.aws.eks.model.UpdateLabelsPayload.ReadOnly {
    override val addOrUpdateLabels: Option[Map[LabelKey, LabelValue]] = scala
      .Option(impl.addOrUpdateLabels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .LabelKey(key) -> zio.aws.eks.model.primitives.LabelValue(value)
          })
          .toMap
      )
    override val removeLabels: Option[List[String]] = scala
      .Option(impl.removeLabels())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateLabelsPayload
  ): zio.aws.eks.model.UpdateLabelsPayload.ReadOnly = new Wrapper(impl)
}
