package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eks.model.primitives.ClusterName
import scala.jdk.CollectionConverters._
final case class DescribeAddonRequest(
    clusterName: ClusterName,
    addonName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonRequest = {
    import DescribeAddonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .addonName(addonName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonRequest.ReadOnly =
    zio.aws.eks.model.DescribeAddonRequest.wrap(buildAwsValue())
}
object DescribeAddonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonRequest =
      zio.aws.eks.model.DescribeAddonRequest(clusterName, addonName)
    def clusterName: ClusterName
    def addonName: String
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getAddonName: ZIO[Any, Nothing, String] = ZIO.succeed(addonName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonRequest
  ) extends zio.aws.eks.model.DescribeAddonRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.clusterName())
    override val addonName: String = impl.addonName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonRequest
  ): zio.aws.eks.model.DescribeAddonRequest.ReadOnly = new Wrapper(impl)
}
