package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ClusterStatus {
  def unwrap: software.amazon.awssdk.services.eks.model.ClusterStatus
}
object ClusterStatus {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ClusterStatus
  ): zio.aws.eks.model.ClusterStatus = value match {
    case software.amazon.awssdk.services.eks.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.eks.model.ClusterStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.CREATING
  }
  case object ACTIVE extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.ACTIVE
  }
  case object DELETING extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.DELETING
  }
  case object FAILED extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.FAILED
  }
  case object UPDATING extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.UPDATING
  }
  case object PENDING extends zio.aws.eks.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterStatus =
      software.amazon.awssdk.services.eks.model.ClusterStatus.PENDING
  }
}
