package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.ListClustersRequestMaxResults
import scala.jdk.CollectionConverters._
final case class ListClustersRequest(
    maxResults: Option[ListClustersRequestMaxResults] = None,
    nextToken: Option[String] = None,
    include: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListClustersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListClustersRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.include)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListClustersRequest.ReadOnly =
    zio.aws.eks.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListClustersRequest =
      zio.aws.eks.model.ListClustersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        include.map(value => value)
      )
    def maxResults: Option[ListClustersRequestMaxResults]
    def nextToken: Option[String]
    def include: Option[List[String]]
    def getMaxResults: ZIO[Any, AwsError, ListClustersRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInclude: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListClustersRequest
  ) extends zio.aws.eks.model.ListClustersRequest.ReadOnly {
    override val maxResults: Option[ListClustersRequestMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.eks.model.primitives.ListClustersRequestMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val include: Option[List[String]] = scala
      .Option(impl.include())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListClustersRequest
  ): zio.aws.eks.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
