package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FargateProfileSelector(
    namespace: Option[String] = None,
    labels: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.FargateProfileSelector = {
    import FargateProfileSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.FargateProfileSelector
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.FargateProfileSelector.ReadOnly =
    zio.aws.eks.model.FargateProfileSelector.wrap(buildAwsValue())
}
object FargateProfileSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.FargateProfileSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.FargateProfileSelector =
      zio.aws.eks.model.FargateProfileSelector(
        namespace.map(value => value),
        labels.map(value => value)
      )
    def namespace: Option[String]
    def labels: Option[Map[String, String]]
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.FargateProfileSelector
  ) extends zio.aws.eks.model.FargateProfileSelector.ReadOnly {
    override val namespace: Option[String] =
      scala.Option(impl.namespace()).map(value => value: String)
    override val labels: Option[Map[String, String]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.FargateProfileSelector
  ): zio.aws.eks.model.FargateProfileSelector.ReadOnly = new Wrapper(impl)
}
