package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IdentityProviderConfigResponse(
    oidc: Option[zio.aws.eks.model.OidcIdentityProviderConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.IdentityProviderConfigResponse = {
    import IdentityProviderConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.IdentityProviderConfigResponse
      .builder()
      .optionallyWith(oidc.map(value => value.buildAwsValue()))(_.oidc)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly =
    zio.aws.eks.model.IdentityProviderConfigResponse.wrap(buildAwsValue())
}
object IdentityProviderConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.IdentityProviderConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.IdentityProviderConfigResponse =
      zio.aws.eks.model
        .IdentityProviderConfigResponse(oidc.map(value => value.asEditable))
    def oidc: Option[zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly]
    def getOidc: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("oidc", oidc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.IdentityProviderConfigResponse
  ) extends zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly {
    override val oidc
        : Option[zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly] = scala
      .Option(impl.oidc())
      .map(value => zio.aws.eks.model.OidcIdentityProviderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.IdentityProviderConfigResponse
  ): zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
