package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAddonResponse(
    addon: Option[zio.aws.eks.model.Addon] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateAddonResponse = {
    import CreateAddonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateAddonResponse
      .builder()
      .optionallyWith(addon.map(value => value.buildAwsValue()))(_.addon)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateAddonResponse.ReadOnly =
    zio.aws.eks.model.CreateAddonResponse.wrap(buildAwsValue())
}
object CreateAddonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateAddonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateAddonResponse = zio.aws.eks.model
      .CreateAddonResponse(addon.map(value => value.asEditable))
    def addon: Option[zio.aws.eks.model.Addon.ReadOnly]
    def getAddon: ZIO[Any, AwsError, zio.aws.eks.model.Addon.ReadOnly] =
      AwsError.unwrapOptionField("addon", addon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateAddonResponse
  ) extends zio.aws.eks.model.CreateAddonResponse.ReadOnly {
    override val addon: Option[zio.aws.eks.model.Addon.ReadOnly] = scala
      .Option(impl.addon())
      .map(value => zio.aws.eks.model.Addon.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateAddonResponse
  ): zio.aws.eks.model.CreateAddonResponse.ReadOnly = new Wrapper(impl)
}
