package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNodegroupResponse(
    nodegroup: Option[zio.aws.eks.model.Nodegroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse = {
    import DescribeNodegroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse
      .builder()
      .optionallyWith(nodegroup.map(value => value.buildAwsValue()))(
        _.nodegroup
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly =
    zio.aws.eks.model.DescribeNodegroupResponse.wrap(buildAwsValue())
}
object DescribeNodegroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeNodegroupResponse =
      zio.aws.eks.model
        .DescribeNodegroupResponse(nodegroup.map(value => value.asEditable))
    def nodegroup: Option[zio.aws.eks.model.Nodegroup.ReadOnly]
    def getNodegroup: ZIO[Any, AwsError, zio.aws.eks.model.Nodegroup.ReadOnly] =
      AwsError.unwrapOptionField("nodegroup", nodegroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse
  ) extends zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly {
    override val nodegroup: Option[zio.aws.eks.model.Nodegroup.ReadOnly] = scala
      .Option(impl.nodegroup())
      .map(value => zio.aws.eks.model.Nodegroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse
  ): zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly = new Wrapper(impl)
}
