package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait AddonIssueCode {
  def unwrap: software.amazon.awssdk.services.eks.model.AddonIssueCode
}
object AddonIssueCode {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.AddonIssueCode
  ): zio.aws.eks.model.AddonIssueCode = value match {
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.CLUSTER_UNREACHABLE =>
      val r = ClusterUnreachable
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.INSUFFICIENT_NUMBER_OF_REPLICAS =>
      val r = InsufficientNumberOfReplicas
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.CONFIGURATION_CONFLICT =>
      val r = ConfigurationConflict
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.ADMISSION_REQUEST_DENIED =>
      val r = AdmissionRequestDenied
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.UNSUPPORTED_ADDON_MODIFICATION =>
      val r = UnsupportedAddonModification
      r
    case software.amazon.awssdk.services.eks.model.AddonIssueCode.K8_S_RESOURCE_NOT_FOUND =>
      val r = K8sResourceNotFound
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDenied extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.ACCESS_DENIED
  }
  case object InternalFailure extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.INTERNAL_FAILURE
  }
  case object ClusterUnreachable extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.CLUSTER_UNREACHABLE
  }
  case object InsufficientNumberOfReplicas
      extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.INSUFFICIENT_NUMBER_OF_REPLICAS
  }
  case object ConfigurationConflict extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.CONFIGURATION_CONFLICT
  }
  case object AdmissionRequestDenied extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.ADMISSION_REQUEST_DENIED
  }
  case object UnsupportedAddonModification
      extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.UNSUPPORTED_ADDON_MODIFICATION
  }
  case object K8sResourceNotFound extends zio.aws.eks.model.AddonIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.AddonIssueCode =
      software.amazon.awssdk.services.eks.model.AddonIssueCode.K8_S_RESOURCE_NOT_FOUND
  }
}
