package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{
  TagValue,
  TagKey,
  RequiredClaimsValue,
  RequiredClaimsKey
}
import scala.jdk.CollectionConverters._
final case class OidcIdentityProviderConfig(
    identityProviderConfigName: Option[String] = None,
    identityProviderConfigArn: Option[String] = None,
    clusterName: Option[String] = None,
    issuerUrl: Option[String] = None,
    clientId: Option[String] = None,
    usernameClaim: Option[String] = None,
    usernamePrefix: Option[String] = None,
    groupsClaim: Option[String] = None,
    groupsPrefix: Option[String] = None,
    requiredClaims: Option[Map[RequiredClaimsKey, RequiredClaimsValue]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    status: Option[zio.aws.eks.model.ConfigStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig = {
    import OidcIdentityProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
      .builder()
      .optionallyWith(
        identityProviderConfigName.map(value => value: java.lang.String)
      )(_.identityProviderConfigName)
      .optionallyWith(
        identityProviderConfigArn.map(value => value: java.lang.String)
      )(_.identityProviderConfigArn)
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(issuerUrl.map(value => value: java.lang.String))(
        _.issuerUrl
      )
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(usernameClaim.map(value => value: java.lang.String))(
        _.usernameClaim
      )
      .optionallyWith(usernamePrefix.map(value => value: java.lang.String))(
        _.usernamePrefix
      )
      .optionallyWith(groupsClaim.map(value => value: java.lang.String))(
        _.groupsClaim
      )
      .optionallyWith(groupsPrefix.map(value => value: java.lang.String))(
        _.groupsPrefix
      )
      .optionallyWith(
        requiredClaims.map(value =>
          value
            .map({ case (key, value) =>
              (RequiredClaimsKey.unwrap(
                key
              ): java.lang.String) -> (RequiredClaimsValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requiredClaims)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly =
    zio.aws.eks.model.OidcIdentityProviderConfig.wrap(buildAwsValue())
}
object OidcIdentityProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OidcIdentityProviderConfig =
      zio.aws.eks.model.OidcIdentityProviderConfig(
        identityProviderConfigName.map(value => value),
        identityProviderConfigArn.map(value => value),
        clusterName.map(value => value),
        issuerUrl.map(value => value),
        clientId.map(value => value),
        usernameClaim.map(value => value),
        usernamePrefix.map(value => value),
        groupsClaim.map(value => value),
        groupsPrefix.map(value => value),
        requiredClaims.map(value => value),
        tags.map(value => value),
        status.map(value => value)
      )
    def identityProviderConfigName: Option[String]
    def identityProviderConfigArn: Option[String]
    def clusterName: Option[String]
    def issuerUrl: Option[String]
    def clientId: Option[String]
    def usernameClaim: Option[String]
    def usernamePrefix: Option[String]
    def groupsClaim: Option[String]
    def groupsPrefix: Option[String]
    def requiredClaims: Option[Map[RequiredClaimsKey, RequiredClaimsValue]]
    def tags: Option[Map[TagKey, TagValue]]
    def status: Option[zio.aws.eks.model.ConfigStatus]
    def getIdentityProviderConfigName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityProviderConfigName",
        identityProviderConfigName
      )
    def getIdentityProviderConfigArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("identityProviderConfigArn", identityProviderConfigArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getIssuerUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuerUrl", issuerUrl)
    def getClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getUsernameClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernameClaim", usernameClaim)
    def getUsernamePrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernamePrefix", usernamePrefix)
    def getGroupsClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsClaim", groupsClaim)
    def getGroupsPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsPrefix", groupsPrefix)
    def getRequiredClaims
        : ZIO[Any, AwsError, Map[RequiredClaimsKey, RequiredClaimsValue]] =
      AwsError.unwrapOptionField("requiredClaims", requiredClaims)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.ConfigStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ) extends zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly {
    override val identityProviderConfigName: Option[String] = scala
      .Option(impl.identityProviderConfigName())
      .map(value => value: String)
    override val identityProviderConfigArn: Option[String] =
      scala.Option(impl.identityProviderConfigArn()).map(value => value: String)
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val issuerUrl: Option[String] =
      scala.Option(impl.issuerUrl()).map(value => value: String)
    override val clientId: Option[String] =
      scala.Option(impl.clientId()).map(value => value: String)
    override val usernameClaim: Option[String] =
      scala.Option(impl.usernameClaim()).map(value => value: String)
    override val usernamePrefix: Option[String] =
      scala.Option(impl.usernamePrefix()).map(value => value: String)
    override val groupsClaim: Option[String] =
      scala.Option(impl.groupsClaim()).map(value => value: String)
    override val groupsPrefix: Option[String] =
      scala.Option(impl.groupsPrefix()).map(value => value: String)
    override val requiredClaims
        : Option[Map[RequiredClaimsKey, RequiredClaimsValue]] = scala
      .Option(impl.requiredClaims())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives.RequiredClaimsKey(
              key
            ) -> zio.aws.eks.model.primitives.RequiredClaimsValue(value)
          })
          .toMap
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val status: Option[zio.aws.eks.model.ConfigStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.ConfigStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ): zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly = new Wrapper(impl)
}
