package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListNodegroupsResponse(
    nodegroups: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListNodegroupsResponse = {
    import ListNodegroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListNodegroupsResponse
      .builder()
      .optionallyWith(
        nodegroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.nodegroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListNodegroupsResponse.ReadOnly =
    zio.aws.eks.model.ListNodegroupsResponse.wrap(buildAwsValue())
}
object ListNodegroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListNodegroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListNodegroupsResponse =
      zio.aws.eks.model.ListNodegroupsResponse(
        nodegroups.map(value => value),
        nextToken.map(value => value)
      )
    def nodegroups: Option[List[String]]
    def nextToken: Option[String]
    def getNodegroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("nodegroups", nodegroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListNodegroupsResponse
  ) extends zio.aws.eks.model.ListNodegroupsResponse.ReadOnly {
    override val nodegroups: Option[List[String]] = scala
      .Option(impl.nodegroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListNodegroupsResponse
  ): zio.aws.eks.model.ListNodegroupsResponse.ReadOnly = new Wrapper(impl)
}
