package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFargateProfileResponse(
    fargateProfile: Option[zio.aws.eks.model.FargateProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse = {
    import CreateFargateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse
      .builder()
      .optionallyWith(fargateProfile.map(value => value.buildAwsValue()))(
        _.fargateProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly =
    zio.aws.eks.model.CreateFargateProfileResponse.wrap(buildAwsValue())
}
object CreateFargateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateFargateProfileResponse =
      zio.aws.eks.model.CreateFargateProfileResponse(
        fargateProfile.map(value => value.asEditable)
      )
    def fargateProfile: Option[zio.aws.eks.model.FargateProfile.ReadOnly]
    def getFargateProfile
        : ZIO[Any, AwsError, zio.aws.eks.model.FargateProfile.ReadOnly] =
      AwsError.unwrapOptionField("fargateProfile", fargateProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse
  ) extends zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly {
    override val fargateProfile
        : Option[zio.aws.eks.model.FargateProfile.ReadOnly] = scala
      .Option(impl.fargateProfile())
      .map(value => zio.aws.eks.model.FargateProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse
  ): zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly = new Wrapper(impl)
}
