package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterVersionRequest(
    name: String,
    version: String,
    clientRequestToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest = {
    import UpdateClusterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest
      .builder()
      .name(name: java.lang.String)
      .version(version: java.lang.String)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateClusterVersionRequest.ReadOnly =
    zio.aws.eks.model.UpdateClusterVersionRequest.wrap(buildAwsValue())
}
object UpdateClusterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateClusterVersionRequest =
      zio.aws.eks.model.UpdateClusterVersionRequest(
        name,
        version,
        clientRequestToken.map(value => value)
      )
    def name: String
    def version: String
    def clientRequestToken: Option[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, String] = ZIO.succeed(version)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest
  ) extends zio.aws.eks.model.UpdateClusterVersionRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val version: String = impl.version(): String
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest
  ): zio.aws.eks.model.UpdateClusterVersionRequest.ReadOnly = new Wrapper(impl)
}
