package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.ListUpdatesRequestMaxResults
import scala.jdk.CollectionConverters._
final case class ListUpdatesRequest(
    name: String,
    nodegroupName: Option[String] = None,
    addonName: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[ListUpdatesRequestMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListUpdatesRequest = {
    import ListUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListUpdatesRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(nodegroupName.map(value => value: java.lang.String))(
        _.nodegroupName
      )
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListUpdatesRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListUpdatesRequest.ReadOnly =
    zio.aws.eks.model.ListUpdatesRequest.wrap(buildAwsValue())
}
object ListUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListUpdatesRequest =
      zio.aws.eks.model.ListUpdatesRequest(
        name,
        nodegroupName.map(value => value),
        addonName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: String
    def nodegroupName: Option[String]
    def addonName: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[ListUpdatesRequestMaxResults]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getNodegroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupName", nodegroupName)
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListUpdatesRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ) extends zio.aws.eks.model.ListUpdatesRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val nodegroupName: Option[String] =
      scala.Option(impl.nodegroupName()).map(value => value: String)
    override val addonName: Option[String] =
      scala.Option(impl.addonName()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[ListUpdatesRequestMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.eks.model.primitives.ListUpdatesRequestMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ): zio.aws.eks.model.ListUpdatesRequest.ReadOnly = new Wrapper(impl)
}
