package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.BoxedBoolean
import scala.jdk.CollectionConverters._
final case class VpcConfigRequest(
    subnetIds: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    endpointPublicAccess: Option[BoxedBoolean] = None,
    endpointPrivateAccess: Option[BoxedBoolean] = None,
    publicAccessCidrs: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.VpcConfigRequest = {
    import VpcConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.VpcConfigRequest
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        endpointPublicAccess.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.endpointPublicAccess)
      .optionallyWith(
        endpointPrivateAccess.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.endpointPrivateAccess)
      .optionallyWith(
        publicAccessCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicAccessCidrs)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.VpcConfigRequest.ReadOnly =
    zio.aws.eks.model.VpcConfigRequest.wrap(buildAwsValue())
}
object VpcConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.VpcConfigRequest =
      zio.aws.eks.model.VpcConfigRequest(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        endpointPublicAccess.map(value => value),
        endpointPrivateAccess.map(value => value),
        publicAccessCidrs.map(value => value)
      )
    def subnetIds: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def endpointPublicAccess: Option[BoxedBoolean]
    def endpointPrivateAccess: Option[BoxedBoolean]
    def publicAccessCidrs: Option[List[String]]
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getEndpointPublicAccess: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("endpointPublicAccess", endpointPublicAccess)
    def getEndpointPrivateAccess: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("endpointPrivateAccess", endpointPrivateAccess)
    def getPublicAccessCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicAccessCidrs", publicAccessCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ) extends zio.aws.eks.model.VpcConfigRequest.ReadOnly {
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val endpointPublicAccess: Option[BoxedBoolean] = scala
      .Option(impl.endpointPublicAccess())
      .map(value => zio.aws.eks.model.primitives.BoxedBoolean(value))
    override val endpointPrivateAccess: Option[BoxedBoolean] = scala
      .Option(impl.endpointPrivateAccess())
      .map(value => zio.aws.eks.model.primitives.BoxedBoolean(value))
    override val publicAccessCidrs: Option[List[String]] = scala
      .Option(impl.publicAccessCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ): zio.aws.eks.model.VpcConfigRequest.ReadOnly = new Wrapper(impl)
}
