package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.BoxedBoolean
import scala.jdk.CollectionConverters._
final case class LogSetup(
    types: Option[Iterable[zio.aws.eks.model.LogType]] = None,
    enabled: Option[BoxedBoolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.LogSetup = {
    import LogSetup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.LogSetup
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.typesWithStrings)
      .optionallyWith(
        enabled.map(value => BoxedBoolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.LogSetup.ReadOnly =
    zio.aws.eks.model.LogSetup.wrap(buildAwsValue())
}
object LogSetup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.LogSetup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.LogSetup = zio.aws.eks.model
      .LogSetup(types.map(value => value), enabled.map(value => value))
    def types: Option[List[zio.aws.eks.model.LogType]]
    def enabled: Option[BoxedBoolean]
    def getTypes: ZIO[Any, AwsError, List[zio.aws.eks.model.LogType]] =
      AwsError.unwrapOptionField("types", types)
    def getEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.LogSetup
  ) extends zio.aws.eks.model.LogSetup.ReadOnly {
    override val types: Option[List[zio.aws.eks.model.LogType]] = scala
      .Option(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.LogType.wrap(item)
        }.toList
      )
    override val enabled: Option[BoxedBoolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.eks.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.LogSetup
  ): zio.aws.eks.model.LogSetup.ReadOnly = new Wrapper(impl)
}
