package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Certificate(data: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Certificate
      .builder()
      .optionallyWith(data.map(value => value: java.lang.String))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Certificate.ReadOnly =
    zio.aws.eks.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Certificate =
      zio.aws.eks.model.Certificate(data.map(value => value))
    def data: Option[String]
    def getData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Certificate
  ) extends zio.aws.eks.model.Certificate.ReadOnly {
    override val data: Option[String] =
      scala.Option(impl.data()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Certificate
  ): zio.aws.eks.model.Certificate.ReadOnly = new Wrapper(impl)
}
