package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcConfigResponse(
    subnetIds: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    clusterSecurityGroupId: Option[String] = None,
    vpcId: Option[String] = None,
    endpointPublicAccess: Option[Boolean] = None,
    endpointPrivateAccess: Option[Boolean] = None,
    publicAccessCidrs: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.VpcConfigResponse = {
    import VpcConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.VpcConfigResponse
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        clusterSecurityGroupId.map(value => value: java.lang.String)
      )(_.clusterSecurityGroupId)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        endpointPublicAccess.map(value => value: java.lang.Boolean)
      )(_.endpointPublicAccess)
      .optionallyWith(
        endpointPrivateAccess.map(value => value: java.lang.Boolean)
      )(_.endpointPrivateAccess)
      .optionallyWith(
        publicAccessCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicAccessCidrs)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.VpcConfigResponse.ReadOnly =
    zio.aws.eks.model.VpcConfigResponse.wrap(buildAwsValue())
}
object VpcConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.VpcConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.VpcConfigResponse =
      zio.aws.eks.model.VpcConfigResponse(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        clusterSecurityGroupId.map(value => value),
        vpcId.map(value => value),
        endpointPublicAccess.map(value => value),
        endpointPrivateAccess.map(value => value),
        publicAccessCidrs.map(value => value)
      )
    def subnetIds: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def clusterSecurityGroupId: Option[String]
    def vpcId: Option[String]
    def endpointPublicAccess: Option[Boolean]
    def endpointPrivateAccess: Option[Boolean]
    def publicAccessCidrs: Option[List[String]]
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getClusterSecurityGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSecurityGroupId", clusterSecurityGroupId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEndpointPublicAccess: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("endpointPublicAccess", endpointPublicAccess)
    def getEndpointPrivateAccess: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("endpointPrivateAccess", endpointPrivateAccess)
    def getPublicAccessCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicAccessCidrs", publicAccessCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigResponse
  ) extends zio.aws.eks.model.VpcConfigResponse.ReadOnly {
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clusterSecurityGroupId: Option[String] =
      scala.Option(impl.clusterSecurityGroupId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val endpointPublicAccess: Option[Boolean] =
      scala.Option(impl.endpointPublicAccess()).map(value => value: Boolean)
    override val endpointPrivateAccess: Option[Boolean] =
      scala.Option(impl.endpointPrivateAccess()).map(value => value: Boolean)
    override val publicAccessCidrs: Option[List[String]] = scala
      .Option(impl.publicAccessCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigResponse
  ): zio.aws.eks.model.VpcConfigResponse.ReadOnly = new Wrapper(impl)
}
