package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{Capacity, ZeroCapacity}
import scala.jdk.CollectionConverters._
final case class NodegroupScalingConfig(
    minSize: Option[ZeroCapacity] = None,
    maxSize: Option[Capacity] = None,
    desiredSize: Option[ZeroCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupScalingConfig = {
    import NodegroupScalingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
      .builder()
      .optionallyWith(
        minSize.map(value => ZeroCapacity.unwrap(value): Integer)
      )(_.minSize)
      .optionallyWith(maxSize.map(value => Capacity.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(
        desiredSize.map(value => ZeroCapacity.unwrap(value): Integer)
      )(_.desiredSize)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupScalingConfig.ReadOnly =
    zio.aws.eks.model.NodegroupScalingConfig.wrap(buildAwsValue())
}
object NodegroupScalingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupScalingConfig =
      zio.aws.eks.model.NodegroupScalingConfig(
        minSize.map(value => value),
        maxSize.map(value => value),
        desiredSize.map(value => value)
      )
    def minSize: Option[ZeroCapacity]
    def maxSize: Option[Capacity]
    def desiredSize: Option[ZeroCapacity]
    def getMinSize: ZIO[Any, AwsError, ZeroCapacity] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, Capacity] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getDesiredSize: ZIO[Any, AwsError, ZeroCapacity] =
      AwsError.unwrapOptionField("desiredSize", desiredSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ) extends zio.aws.eks.model.NodegroupScalingConfig.ReadOnly {
    override val minSize: Option[ZeroCapacity] = scala
      .Option(impl.minSize())
      .map(value => zio.aws.eks.model.primitives.ZeroCapacity(value))
    override val maxSize: Option[Capacity] = scala
      .Option(impl.maxSize())
      .map(value => zio.aws.eks.model.primitives.Capacity(value))
    override val desiredSize: Option[ZeroCapacity] = scala
      .Option(impl.desiredSize())
      .map(value => zio.aws.eks.model.primitives.ZeroCapacity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ): zio.aws.eks.model.NodegroupScalingConfig.ReadOnly = new Wrapper(impl)
}
