package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.FargateProfilesRequestMaxResults
import scala.jdk.CollectionConverters._
final case class ListFargateProfilesRequest(
    clusterName: String,
    maxResults: Option[FargateProfilesRequestMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest = {
    import ListFargateProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          FargateProfilesRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListFargateProfilesRequest.ReadOnly =
    zio.aws.eks.model.ListFargateProfilesRequest.wrap(buildAwsValue())
}
object ListFargateProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListFargateProfilesRequest =
      zio.aws.eks.model.ListFargateProfilesRequest(
        clusterName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterName: String
    def maxResults: Option[FargateProfilesRequestMaxResults]
    def nextToken: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getMaxResults: ZIO[Any, AwsError, FargateProfilesRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest
  ) extends zio.aws.eks.model.ListFargateProfilesRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val maxResults: Option[FargateProfilesRequestMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.eks.model.primitives.FargateProfilesRequestMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest
  ): zio.aws.eks.model.ListFargateProfilesRequest.ReadOnly = new Wrapper(impl)
}
