package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KubernetesNetworkConfigResponse(
    serviceIpv4Cidr: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse = {
    import KubernetesNetworkConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
      .builder()
      .optionallyWith(serviceIpv4Cidr.map(value => value: java.lang.String))(
        _.serviceIpv4Cidr
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly =
    zio.aws.eks.model.KubernetesNetworkConfigResponse.wrap(buildAwsValue())
}
object KubernetesNetworkConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.KubernetesNetworkConfigResponse =
      zio.aws.eks.model
        .KubernetesNetworkConfigResponse(serviceIpv4Cidr.map(value => value))
    def serviceIpv4Cidr: Option[String]
    def getServiceIpv4Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceIpv4Cidr", serviceIpv4Cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ) extends zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly {
    override val serviceIpv4Cidr: Option[String] =
      scala.Option(impl.serviceIpv4Cidr()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ): zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
