package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KubernetesNetworkConfigRequest(
    serviceIpv4Cidr: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest = {
    import KubernetesNetworkConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest
      .builder()
      .optionallyWith(serviceIpv4Cidr.map(value => value: java.lang.String))(
        _.serviceIpv4Cidr
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly =
    zio.aws.eks.model.KubernetesNetworkConfigRequest.wrap(buildAwsValue())
}
object KubernetesNetworkConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.KubernetesNetworkConfigRequest =
      zio.aws.eks.model
        .KubernetesNetworkConfigRequest(serviceIpv4Cidr.map(value => value))
    def serviceIpv4Cidr: Option[String]
    def getServiceIpv4Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceIpv4Cidr", serviceIpv4Cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest
  ) extends zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly {
    override val serviceIpv4Cidr: Option[String] =
      scala.Option(impl.serviceIpv4Cidr()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest
  ): zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
