package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAddonVersionsResponse(
    addons: Option[Iterable[zio.aws.eks.model.AddonInfo]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse = {
    import DescribeAddonVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
      .builder()
      .optionallyWith(
        addons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addons)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly =
    zio.aws.eks.model.DescribeAddonVersionsResponse.wrap(buildAwsValue())
}
object DescribeAddonVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonVersionsResponse =
      zio.aws.eks.model.DescribeAddonVersionsResponse(
        addons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addons: Option[List[zio.aws.eks.model.AddonInfo.ReadOnly]]
    def nextToken: Option[String]
    def getAddons
        : ZIO[Any, AwsError, List[zio.aws.eks.model.AddonInfo.ReadOnly]] =
      AwsError.unwrapOptionField("addons", addons)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ) extends zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly {
    override val addons: Option[List[zio.aws.eks.model.AddonInfo.ReadOnly]] =
      scala
        .Option(impl.addons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.AddonInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ): zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
